/*!
 * @file        usb_user.h
 *
 * @brief       usb user function
 *
 * @version     V1.0.0
 *
 * @date        2022-05-25
 *
 */
#ifndef __USB_USER_H
#define __USB_USER_H

#include "apm32f4xx.h"

/** User callback function type define */
typedef void (*USER_CallBack_T)(void);

typedef void (*USER_DelayCallBack_T)(uint32_t );

/**
 * @brief   USB User Callback handler
 */
typedef struct
{
    USER_CallBack_T USER_DeviceReset;
    USER_CallBack_T USER_DeviceSuspend;
    USER_CallBack_T USER_DeviceResume;
    USER_DelayCallBack_T delay;
} USB_UserCallBack_T;

extern USB_UserCallBack_T g_userCallback;

#endif
